﻿import QtQml
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Dialogs

import BigScriptCommand

Rectangle {
    id: thiz
    color: Playbook.backgroundColor

    BigScriptCommand {
        id: remote

        onSubcommandStart: function(host){
            Playbook.log(host+": command start: ")
        }

        onSubcommandFinished: function(host, code){
            Playbook.log(host+": command finish: exit code: "+code)
        }

        onDataArrived: function(host, data) {
            Playbook.log(data)
        }

        onErrorArrived: function(host, error){
            Playbook.log(host, error)
        }
    }

    ColumnLayout {
        anchors.fill: parent

        Label {
            text: "Remote hosts:"
        }

        RowLayout {
            Layout.fillWidth: true
            MyTextField {
                Layout.fillWidth: true
                Layout.preferredHeight: 25  
                id: hosts                
            }
            
            Button {
                text: "choose"
                onClicked: {
                    let host = Playbook.hostChooser()
                    if(host === "") {
                        return;
                    }

                    if(hosts.text === "") {
                        hosts.text = host;
                    }else{
                        hosts.text += "," + host;
                    }
                }
            }
        }

        Label {
            text: "Remote command:"
        }

        RowLayout {
            Layout.fillWidth: true
            TextArea {
                Layout.fillWidth: true
                id: cmd
                Component.onCompleted: {
                    cmd.append("#!/usr/bin/env bash")
                    cmd.append("df -h")
                    cmd.append("ps -ef")
                    cmd.append("ping -c 3 127.0.0.1")
                    cmd.append("ls woterm")
                    cmd.append("if [ $? -eq 0 ]; then")
                    cmd.append("  echo \"yes, it is ok\"")
                    cmd.append("else")
                    cmd.append("  echo \"Sorry, it is bad\"")
                    cmd.append("fi")
                }
            }
        }
        Row {
            Layout.alignment: Qt.AlignHCenter
            Button {
                text: "Start"
                onClicked: {
                    Playbook.logClear();
                    if(cmd.text === "") {
                        Playbook.log("the command text is empty.")
                        return
                    }
                    if(hosts.text === "") {
                        Playbook.log("the hosts is empty.")
                        return
                    }

                    asyncGenerator(function *(){
                        Playbook.log("script start.")
                        remote.hosts = hosts.text.split(',')
                        yield bigScriptCommand(remote, cmd.text).catch(function(){})
                        Playbook.log("script finish.")
                    })();
                }
            }
            Button {
                text: "Abort"

                onClicked: {
                    remote.abort()
                }
            }
        }
        Item {
            Layout.fillHeight: true
        }
    }
}
