﻿import QtQml
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Dialogs
import QtQuick.Controls.Basic

Rectangle {
    id: thiz
    color: Playbook.backgroundColor
    Component.onCompleted: {
        Playbook.openTerminal()
    }

    function resizeTerminal() {
        Playbook.adjustTerminal()
    }

    TabBar {
        id: tabBar
        width: parent.width
        position: TabBar.Footer
        TabButton {
            text: "LocalDir"
            onClicked: tabView.replace("TestLocalDir.qml")
        }
        TabButton {
            text: "LocalFile"
            onClicked: tabView.replace("TestLocalFile.qml")
        }
        TabButton {
            text: "LocalCommand"
            onClicked: tabView.replace("TestLocalCommand.qml")
        }
        TabButton {
            text: "RemoteCommand"
            onClicked: tabView.replace("TestRemoteCommand.qml")
        }
        TabButton {
            text: "FileContentCommand"
            onClicked: tabView.replace("TestFileContentCommand.qml")
        }
        TabButton {
            text: "FileListCommand"
            onClicked: tabView.replace("TestFileListCommand.qml")
        }
        TabButton {
            text: "FileTransferCommand"
            onClicked: tabView.replace("TestFileTransferCommand.qml")
        }
        TabButton {
            text: "BigScriptCommand"
            onClicked: tabView.replace("TestBigScriptCommand.qml")
        }
        TabButton {
            text: "HttpCommand"
            onClicked: tabView.replace("TestHttpCommand.qml")
        }
        TabButton {
            text: "CustomCommand"
            onClicked: tabView.replace("TestCustomCommand.qml")
        }
    }
    StackView {
        id: tabView
        x: 0
        y: tabBar.height
        width: parent.width
        height: parent.height - tabBar.height
        Component.onCompleted: {
            Qt.callLater(thiz.resizeTerminal)
            tabView.currentItemChanged.connect(function() {
                Qt.callLater(thiz.resizeTerminal)
                console.log("Current Item changed to:", tabView.currentItem)
            })
        }

        initialItem: "TestLocalDir.qml"

        popEnter: Transition {
            // No animation
        }
        popExit: Transition {
            // No animation
        }
        pushEnter: Transition {
            // No animation
        }
        pushExit: Transition {
            // No animation
        }
        replaceEnter: Transition {
            // No animation
        }
        replaceExit: Transition {
            // No animation
        }
    }
}
