﻿import QtQml
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Dialogs
import QtQuick.Controls.Basic

Rectangle {
    property alias placeholderText: input.placeholderText
    property alias readyOnly: input.readOnly
    property alias text: input.text

    border.color: Playbook.textColor
    color: "transparent"

    function append(txt) {
        input.append(txt)
    }
    ScrollView{
        anchors.fill: parent
        clip: true

        background: Item {}
        
        TextArea{
            id: input
            color: Playbook.textColor
            font.pointSize: 12
            selectByMouse: true
            mouseSelectionMode: TextInput.SelectWords
            wrapMode: TextEdit.WrapAnywhere
            background: Item {}
        }
        ScrollBar.horizontal.policy: ScrollBar.AlwaysOff
        ScrollBar.vertical.policy: ScrollBar.AlwaysOn
    }
}
